<?php

namespace Move\Specification;

use NewcomDigital\Enum\Enum;

/**
 * Class EnumSpecification
 * @package Move\Specification
 */
class EnumSpecification extends Specification
{
    /**
     * @var string
     */
    private $enumClass;

    /**
     * EnumSpecification constructor.
     * @param string $enumClass
     * @throws \InvalidArgumentException
     */
    public function __construct($enumClass)
    {
        try {
            if (!(new \ReflectionClass($enumClass))->isSubclassOf(Enum::class)) {
                throw new \InvalidArgumentException('class ' . $enumClass . ' does not extend Enum class');
            }
        } catch (\ReflectionException $e) {
            throw new \InvalidArgumentException('class ' . $enumClass . ' does not exist', null, $e);
        }
        $this->enumClass = $enumClass;
    }

    /**
     * @param mixed $object
     * @return bool
     * @throws \InvalidArgumentException
     */
    public function isSatisfiedBy($object) : bool
    {
        try {
            if ($object instanceof $this->enumClass) {
                return true;
            }
            new $this->enumClass($object);
        } catch (\Exception $e) {
            return false;
        }
        return true;
    }
}
