<?php

namespace Move\Specification;

/**
 * Class OrSpecification
 * @package Move\Specification
 */
class OrSpecification extends Specification
{

    /**
     * @var SpecificationInterface
     */
    private $specification1;

    /**
     * @var SpecificationInterface
     */
    private $specification2;

    /**
     * @param SpecificationInterface $specification1
     * @param SpecificationInterface $specification2
     */
    public function __construct(SpecificationInterface $specification1, SpecificationInterface $specification2)
    {
        $this->specification1 = $specification1;
        $this->specification2 = $specification2;
    }

    /**
     * @inheritdoc
     */
    public function isSatisfiedBy($object) : bool
    {
        return $this->specification1->isSatisfiedBy($object)
        || $this->specification2->isSatisfiedBy($object);
    }
}
