<?php


namespace Move\Template\Html\Asset;

use Move\Utils\Str;

/**
 * Class Weborama
 * @package Move\Template\Html\Asset
 */
class Weborama implements AssetInterface
{

    /** @var  array */
    protected static $KEYS = [];

    /** @var string */
    private $wamId;

    /** @var string */
    private $scriptURL;

    /**
     * GoogleAnalytics constructor.
     * @param string $wamId
     * @param string|null $scriptURL
     */
    public function __construct(string $wamId, string $scriptURL = null)
    {
        $this->wamId = $wamId;
        $this->scriptURL = $scriptURL ?: '//cstatic.weborama.fr/js/wam/customers/wamfactory_dpm.wildcard.min.js';
    }

    /**
     * @param string $tagName
     * @param string|array $value
     * @param bool $append
     */
    public static function addSegmentTag(string $tagName, $value, bool $append = true)
    {
        if (!\is_array($value)) {
            $value = [$value];
        }
        if ($append) {
            self::$KEYS[$tagName] = array_merge(self::$KEYS[$tagName] ?? [], $value);
        } else {
            self::$KEYS[$tagName] = $value;
        }
    }

    /**
     * @param string $userId
     */
    public static function setUserId(string $userId)
    {
        static::addSegmentTag('userid', $userId, false);
    }

    /**
     * Renvoi la copie sous forme de tableau de la metadata
     * @return array
     */
    public function getArrayCopy()
    {
        return [
            'keys' => self::$KEYS,
            'wamid' => $this->wamId,
            'scriptURL' => $this->scriptURL,
        ];
    }

    /**
     * Effectue un rendu de l'objet en HTML
     * @return string
     */
    public function __toString()
    {
        $scriptURL = $this->scriptURL;
        $wamId = $this->wamId;
        if (empty($wamId) || empty($scriptURL)) {
            trigger_error('cannot render weborama tag, config uncomplete', E_USER_WARNING);
            return '<!--# weborama:config incomplete #-->';
        }

        $cmdScript = 'var Wvar={};';
        if (!empty(self::$KEYS)) {
            foreach (self::$KEYS as &$value) {
                if (count($value) === 1) {
                    $value = $value[0];
                }
            }
            unset($value);
            try {
                $cmdScript = 'var Wvar=' . Str::toJson(self::$KEYS) . ';';
            } catch (\Exception $e) {
                trigger_error(
                    'cannot json encode weborama vars : ' . $e->getMessage(),
                    E_USER_WARNING
                );
            }
        }

        return <<<EOF
<script type='text/javascript'>
var wamid='$wamId';
var typ='1';
$cmdScript
(function(){
    var w = document.createElement("script");
    w.type = "text/javascript"; w.async = true;
    w.src = document.location.protocol + "$scriptURL?rnd="+new Date().getTime();
    var body = document.getElementsByTagName('script')[0];
    body.parentNode.insertBefore(w,body);
})();
</script>
EOF;
    }
}
