<?php


namespace Move\Template;

use League\Plates\Engine;
use Move\Template\Extensions\MetaHtml;
use Move\Template\Html\Meta\MetaCollection;
use Move\Template\Html\Meta\MetaInterface;

/**
 * Class MetaEngineTrait
 * @package Move\Template
 */
trait MetaEngineTrait
{

    /**
     * @return Engine
     */
    abstract function getEngine();

    /**
     * @param MetaInterface[]|MetaCollection|MetaInterface $metas
     * @param array $tags
     * @return $this
     * @throws \InvalidArgumentException
     */
    protected function addMetas($metas, array $tags = [])
    {
        if (!$metas instanceof MetaCollection) {
            if ($metas instanceof MetaInterface) {
                $metas = [$metas];
            }
            if (!\is_array($metas)) {
                throw new \InvalidArgumentException('must be an array of MetaInterface');
            }
            $metas = (new MetaCollection())->addMulti($metas, $tags);
        }
        $this->getEngine()->loadExtension(new MetaHtml($metas));
        return $this;
    }
}
