<?php

namespace Cms\Bootstrap;

use Cms\Client\CmsHttpClientInterface;
use Cms\Client\CmsStatsHttpClientInterface;
use GuzzleHttp\Client;
use League\Container\Argument\RawArgument;
use League\Container\ContainerInterface;
use Move\Bootstrap\BootstrapInterface;
use Move\Config;
use Move\Http\Client\GuzzleClientAdapter;
use Move\Http\Client\GuzzleClientFactory;
use Move\Http\Client\HttpRequestOptions;

/**
 * Class CmsClientBootstrap
 * @package Cms\Bootstrap
 */
class CmsClientBootstrap implements BootstrapInterface
{

    /** @var \Move\Config */
    protected $config;

    /**
     * CmsClientBootstrap constructor.
     * @param \Move\Config $config
     */
    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    /**
     * @param \League\Container\ContainerInterface $container
     * @return void
     * @throws \DomainException
     */
    public function bootstrap(ContainerInterface $container)
    {
        // check valeur
        if (!isset($this->config['api.cms.host'], $this->config['api.stats.host'])) {
            throw new \DomainException('host for api & stats must be provided');
        }

        // ajout du client principal pour le Cms
        $container->share(CmsHttpClientInterface::class, GuzzleClientAdapter::class)
            ->withArguments([
                new RawArgument(GuzzleClientFactory::create()),
                new RawArgument($this->config['api.cms.hostname'] ?? $this->config['api.cms.host']),
                new RawArgument([
                    HttpRequestOptions::HEADERS => [
                        'Host' => $this->config['api.cms.host'],
                    ],
                ]),
            ]);
        $container->share(CmsStatsHttpClientInterface::class, GuzzleClientAdapter::class)
            ->withArguments([
                new RawArgument(GuzzleClientFactory::create()),
                new RawArgument($this->config['api.stats.hostname'] ?? $this->config['api.stats.host']),
                new RawArgument([
                    HttpRequestOptions::HEADERS => [
                        'Host' => $this->config['api.stats.host'],
                    ],
                ]),
            ]);
    }
}
