<?php

namespace Cms\Client\Service;

use Cms\Client\CmsHttpClientInterface;
use Cms\Client\Navigation\NavigationItemClient;
use League\Container\ServiceProvider\AbstractServiceProvider;

/**
 * Class NavigationProvider
 * @package Cms\Client\Service
 */
class NavigationProvider extends AbstractServiceProvider
{

    /** @var array */
    protected $provides = [
        NavigationItemClient::class,
        NavigationService::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        // add clients
        $this->container->add(NavigationItemClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add services
        $this->container->add(NavigationService::class)
            ->withArguments([
                NavigationItemClient::class,
            ]);
    }
}
