<?php


namespace Cms\Client\Service;

/**
 * Trait NavigationServiceAwareTrait
 * @package Cms\Client\Service
 */
trait NavigationServiceAwareTrait
{

    /** @var  \Cms\Client\Service\NavigationService */
    protected $navigationService;

    /**
     * @param \Cms\Client\Service\NavigationService $navigationService
     * @return $this
     */
    public function setNavigationService(NavigationService $navigationService)
    {
        $this->navigationService = $navigationService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\NavigationService
     * @throws \DomainException
     */
    public function getNavigationService() : NavigationService
    {
        if (!$this->navigationService instanceof NavigationService) {
            throw new \DomainException('navigationService is not a NavigationService instance');
        }
        return $this->navigationService;
    }
}
