<?php

namespace Cms\Extension\TemplateBloc;

use Move\Command\Chain\AbstractHandler;

/**
 * Class AbstractBlocHandler
 * @package Cms\Extension\TemplateBloc\TemplateBlocHandler
 */
abstract class AbstractBlocHandler extends AbstractHandler
{

    /**
     * @param BlocHandlerRequest $request
     * @return BlocHandlerResponse|null
     */
    protected function process($request)
    {
        if (!$request instanceof BlocHandlerRequest) {
            throw new \InvalidArgumentException('request invalid');
        }
        $blocResponse = $this->handleBloc($request->getBlocModel());
        if ($blocResponse !== null && !$blocResponse instanceof BlocHandlerResponse) {
            $blocResponse = new BlocHandlerResponse($blocResponse);
        }
        return $blocResponse;
    }

    /**
     * @param mixed $blocModel
     * @return null|BlocHandlerResponse|mixed
     */
    abstract protected function handleBloc($blocModel);
}
