<?php


namespace Cms\Model\AddressBook\Address;

use Cms\Model\Geodata\GeodataAwareModelInterface;
use Cms\Model\Geodata\GeodataAwareModelTrait;
use Cms\Model\GpsLocationPointModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;
use POM\PredefinedType\GpsLocationPoint;

/**
 * Class AddressModel
 * @package Cms\Model\AddressBook\Address
 * @property int $id
 * @property string $description
 * @property string $firm
 * @property string $name
 * @property string $name_complt
 * @property string $address1
 * @property string $address2
 * @property string $postal_code
 * @property string $city_name
 * @property string $city_osm_id
 * @property string $city_name_complt
 * @property \POM\PredefinedType\GpsLocationPoint $gps_location
 * @property bool $is_geocoded
 */
class AddressModel extends DomainObjectAbstract implements GeodataAwareModelInterface
{
    use GeodataAwareModelTrait;
    use StampAwareModelTrait;
    use GpsLocationPointModelTrait {
        propertySet as gpsOffsetSet;
    }

    /** @var  int */
    protected $id;

    /** @var  string */
    protected $description;

    /** @var  string */
    protected $firm;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $name_complt;

    /** @var  string */
    protected $address1;

    /** @var  string */
    protected $address2;

    /** @var  string */
    protected $postal_code;

    /** @var  string */
    protected $city_name;

    /** @var  string */
    protected $city_name_complt;

    /** @var  string */
    protected $city_osm_id;

    /** @var  \POM\PredefinedType\GpsLocationPoint */
    protected $gps_location;

    /** @var  bool */
    protected $is_geocoded;

    /**
     * @inheritdoc
     */
    public function propertyGet($name)
    {
        $result = parent::propertyGet($name);
        if ($result instanceof GpsLocationPoint
            && (!$result->latitude || !$result->longitude)) {
            $result = null;
        }
        return $result;
    }

    /**
     * @inheritdoc
     */
    public function propertySet($offset, $value)
    {
        if ($offset === 'gps_location') {
            if (is_scalar($value)) {
                $value = trim($value);
            }
            if (\is_array($value) && isset($value['latitude'], $value['longitude'])) {
                $value = (new GpsLocationPoint())->populate([
                    'latitude' => str_replace(',', '.', $value['latitude']),
                    'longitude' => str_replace(',', '.', $value['longitude']),
                ], true);
            }
            if ($value instanceof GpsLocationPoint) {
                parent::propertySet($offset, $value);
            } elseif (!empty($value)) {
                $this->gpsOffsetSet($offset, $value);
            } else {
                parent::propertySet($offset, null);
            }
        } else {
            parent::propertySet($offset, $value);
        }
    }
}
