<?php


namespace Cms\Model\Article;

use NewcomDigital\Enum\Enum;

/**
 * Class ArticleState
 * @package Cms\Model\Article
 */
class ArticleState extends Enum
{

    /** Article publié */
    public const PUBLISH = 'publish';

    /** Article corrigé (state temporaire en cas de mise a jour du status) */
    public const CORRECT = 'correct';

    /** Article supprimé */
    public const DELETE = 'delete';

    /** Article en brouillon */
    public const DRAFT = 'draft';

    /** Article en embargo */
    public const EMBARGO = 'embargo';

    /** Le SR doit passer sur le papier */
    public const ATTENTE_SR = 'waitsr';

    /** Le SR a valider le papier */
    public const VALIDE_SR = 'validsr';
}
