<?php


namespace Cms\Model\Geodata;

/**
 * Class GeodataReferenceModelTrait
 * @package Cms\Model\Geodata
 * @property string $city_geodata_id
 * @property string $country_alpha2
 * @property string $admin1_code
 * @property string $admin2_code
 */
trait GeodataAwareModelTrait
{

    /** @var  string */
    protected $city_geodata_id;

    /** @var  string */
    protected $country_alpha2;

    /** @var  string */
    protected $admin1_code;

    /** @var  string */
    protected $admin2_code;


    /**
     * @return null|string
     */
    public function getAdmin2CodeConcat()
    {
        if (!empty($this->admin2_code)
            && !empty($this->admin1_code)
            && !empty($this->country_alpha2)
        ) {
            return $this->country_alpha2 . '.' . $this->admin1_code . '.' . $this->admin2_code;
        }
        return null;
    }

    /**
     * @return null|string
     */
    public function getAdmin1CodeConcat()
    {
        if (!empty($this->admin1_code)
            && !empty($this->country_alpha2)
        ) {
            return $this->country_alpha2 . '.' . $this->admin1_code;
        }
        return null;
    }

    /**
     * @return int
     */
    public function getAdmin1Code()
    {
        return $this->admin1_code;
    }

    /**
     * @return int
     */
    public function getAdmin2Code()
    {
        return $this->admin2_code;
    }

    /**
     * @return string
     */
    public function getCountryCode()
    {
        return $this->country_alpha2;
    }

    /**
     * @return int
     */
    public function getCityGeodataId()
    {
        return $this->city_geodata_id;
    }
}
