<?php

namespace Move\Search\Analyzer;

/**
 * Class FrenchSearchAnalyzer
 * @package Move\Search\Analyzer
 */
class FrenchSearchAnalyzer extends ElasticAnalyzer
{

    /**
     * FrenchSearchAnalyzer constructor.
     * @param string|null $name
     */
    public function __construct(string $name = null)
    {
        parent::__construct($name ?: 'french_search_analyzer', 'standard');
        $this
            ->setFilter('standard')
            ->setFilter('lowercase')
            ->setFilter('french_elision', PredefinedFilterAnalyzer::FILTER_FRENCH_ELISION)
            ->setFilter('french_stop', PredefinedFilterAnalyzer::FILTER_FRENCH_STOP)
            ->setFilter('asciifolding')
            ->setFilter('french_stemmer', PredefinedFilterAnalyzer::FILTER_FRENCH_STEMMER);
    }
}
