<?php

namespace Move\Command;

use PHPUnit\Framework\TestCase;

/**
 * Class CommandBusAwareTest
 * @package Move\Command
 */
class CommandBusAwareTest extends TestCase
{

    /**
     * @expectedException \UnexpectedValueException
     * @return CommandBusAwareTrait
     */
    public function testGetCommandBusEmpty()
    {
        $bus = $this->getMockForTrait(CommandBusAwareTrait::class);
        $this->assertNull($bus->getCommandBus());
        return $bus;
    }

    /**
     * @return CommandBusAwareTrait
     */
    public function testSetCommandBus()
    {
        $cmdBus = $this->createMock(CommandBusInterface::class);
        $bus = $this->getMockForTrait(CommandBusAwareTrait::class);
        $this->assertEquals($bus, $bus->setCommandBus($cmdBus));
        return $bus;
    }

    /**
     * @depends      testSetCommandBus
     * @param CommandBusAwareTrait $bus
     */
    public function testGetCommandBus($bus)
    {
        $this->assertInstanceOf(
            CommandBusInterface::class,
            $bus->getCommandBus()
        );
    }

}
