<?php

namespace Cms\Client\AddressBook\Model;

use Cms\Client\AttributeAwareModelTrait;
use Cms\Client\BackdateModelTrait;
use Cms\Model\AddressBook\Trip\TripAttributeModel;
use Cms\Model\AddressBook\Trip\TripModel;
use Cms\Model\AddressBook\Trip\TripStepModel;

/**
 * Class TripRestfulModel
 * @package Cms\Client\AddressBook\Model
 * @property array $resources
 * @property TripAssetRestfulModel[] $assets
 * @property \Cms\Model\AddressBook\Trip\TripStepModel[] $steps
 * @property \Cms\Model\AddressBook\Trip\TripCategoryModel $category
 */
class TripRestfulModel extends TripModel
{
    use AttributeAwareModelTrait;
    use BackdateModelTrait;

    /** @var  TripAssetRestfulModel[] */
    protected $assets;

    /** @var  \Cms\Model\AddressBook\Trip\TripStepModel[] */
    protected $steps;

    /** @var  \Cms\Model\AddressBook\Trip\TripCategoryModel */
    protected $category;

    /**
     * @param TripStepModel $stepModel
     * @return $this
     */
    public function addStep(TripStepModel $stepModel)
    {
        $this->steps[] = $stepModel;
        return $this;
    }

    /**
     * @param TripAttributeModel|array $attributeData
     * @return TripAttributeModel
     */
    public function handleAttribute($attributeData)
    {
        if (!$attributeData instanceof TripAttributeModel) {
            $attributeData = (new TripAttributeModel())->populate($attributeData, true);
        }
        return $attributeData;
    }
}
