<?php


namespace Cms\Client\Command;

use Move\Http\Client\Exception\HttpRequestException;
use Psr\Log\LoggerInterface;
use Psr\Log\LogLevel;

/**
 * Class CommandExceptionHandleTrait
 * @package Cms\Client\Command
 */
trait CommandExceptionHandleTrait
{

    /**
     * @param string $identifier
     * @param HttpRequestException $e
     */
    protected function logHttpRequestException($identifier, HttpRequestException $e)
    {
        $type = 'CmdRequestError';
        $msg = $type . ' ' . $identifier . ' "' . $e->getMessage() . '"';
        if ($this->logger instanceof LoggerInterface) {
            $level = LogLevel::ALERT;
            $ctx = [
                'err_class' => \get_class($e),
                'err_type' => $type,
                'err_message' => $e->getMessage(),
                'err_ident' => $identifier,
                'request_uri' => (string)$e->getRequest()->getUri(),
                'request_meth' => $e->getRequest()->getMethod(),
                'exception' => $e,
            ];
            if ($e->hasResponse()) {
                $ctx = array_merge($ctx, [
                    'response_code' => $e->getResponse()->getStatusCode(),
                    'response_reason' => $e->getResponse()->getReasonPhrase(),
                ]);
                // cas des 503 (varnish), on va les logger de lanière différente
                if ((int)$e->getResponse()->getStatusCode() === 503) {
                    $ctx['err_message'] = '503 Backend fetch failed';
                }
            }
            $this->logger->log($level, $msg, $ctx);
        } else {
            trigger_error($msg, E_USER_WARNING);
        }
    }
}
