<?php

namespace Cms\Model;

/**
 * Class ConfigAwareModelTrait
 * @package Cms\Model
 * @property \Cms\Model\AbstractConfigModel $config
 */
trait ConfigAwareModelTrait
{

    /** @var  \Cms\Model\ConfigModelFactory::createSafeConfig */
    protected $config;

    /**
     * @param string|mixed $data
     * @return array|mixed
     * @throws \InvalidArgumentException
     * @throws \RuntimeException
     * @deprecated
     */
    public static function decodeConfigToArray($data)
    {
        return ConfigModelFactory::decodeConfigToArray($data);
    }

    /**
     * @param AbstractConfigModel|mixed $data
     * @return AbstractConfigModel|null
     * @throws \RuntimeException
     * @throws \InvalidArgumentException
     * @throws \UnexpectedValueException
     * @deprecated
     */
    public static function createConfig($data)
    {
        return ConfigModelFactory::createConfig($data);
    }

    /**
     * @param mixed $value
     * @return $this
     */
    public function setConfig($value)
    {
        $this->config = ConfigModelFactory::createSafeConfig($value);
        return $this;
    }

    /**
     * @return \Cms\Model\AbstractConfigModel|null
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \InvalidArgumentException
     */
    public function getConfig()
    {
        return ConfigModelFactory::createConfig($this->config);
    }
}
