<?php

namespace Cms\Serializer;

use Cms\DashParser\Entity\EntityEmbed;
use Cms\DashParser\Entity\EntityInterface;
use function Cms\DashParser\load_html;
use Move\Embed\EmbedMapper;
use Move\Embed\EmbedModel;

/**
 * Class HtmlEntityEmbedConverter
 * @package Cms\Serializer
 */
class HtmlEntityEmbedConverter extends \Cms\DashParser\Serializer\HtmlEntityEmbedConverter
{

    /** @var EmbedMapper */
    protected $embedMapper;

    /**
     * HtmlEntityConverter constructor.
     * @param EmbedMapper $embedMapper
     */
    public function __construct(
        EmbedMapper $embedMapper
    ) {
        $this->embedMapper = $embedMapper;
    }

    /**
     * @param \DOMDocument $doc
     * @param EntityInterface $entity
     * @param string $nodeText
     * @return \DOMElement|\DOMNode
     * @throws \Psr\Cache\InvalidArgumentException
     */
    public function getEntityNode(\DOMDocument $doc, EntityInterface $entity, $nodeText = null)
    {
        if (!$entity instanceof EntityEmbed) {
            return null;
        }

        $embedUrl = $entity->getUrl();
        try {
            $embedModel = $this->embedMapper->fetchModel($embedUrl);
            if ($embedModel instanceof EmbedModel) {
                // suppression des entrée
                $contentHtml = $embedModel->html;
                if ($embedModel->provider_name !== 'Twitter'
                    && $embedModel->provider_name !== 'Instagram'
                ) {
                    $contentHtml = "<div class=\"embed-container\">$contentHtml</div>";
                }
                load_html($doc, $contentHtml);
                return $doc->firstChild;
            }
        } catch (\Exception $e) {
            trigger_error('Error while getting embed model : ' . $e);
        }

        $iframe = parent::getEntityNode($doc, $entity, $nodeText);
        $divNode = $doc->createElement('div');
        $divNode->setAttribute('class', 'embed-container');
        $divNode->appendChild($iframe);
        return $divNode;
    }
}
