<?php

namespace Cms\Specification;

use Move\Specification\PatternSpecification;
use Move\Specification\Specification;

/**
 * Class SlugSpecification
 * @package Cms\Specification
 */
class SlugSpecification extends Specification
{

    /**
     * @inheritdoc
     */
    public function isSatisfiedBy($object) : bool
    {
        return (new PatternSpecification('^[a-z-0-9]+$'))->isSatisfiedBy($object);
    }
}
