<?php


namespace Move\Template\Html\Asset;

/**
 * Class Less
 * @package Move\Template\Html\Asset
 */
class Less extends Css
{

    /**
     * @var string
     */
    private $publicPath;

    /**
     * Less constructor.
     * @param string $publicPath
     * @param null|string $src
     * @param null|string $condition
     * @param bool $media
     * @param bool $async
     */
    public function __construct($publicPath, $src, $condition = null, $media = null, $async = false)
    {
        $this->publicPath = $publicPath;
        parent::__construct($src, $condition, $media, $async);
    }

    /**
     * @return string
     */
    public function render()
    {
        try {
            $infile = $this->publicPath . DIRECTORY_SEPARATOR . pathinfo($this->src, PATHINFO_BASENAME);
            $outfile = $this->publicPath . DIRECTORY_SEPARATOR . pathinfo($this->src, PATHINFO_FILENAME) . '.css';
            (new \lessc())->checkedCompile($infile, $outfile);
            $this->src = str_replace('.less', '.css', $this->src);
            return parent::render();
        } catch (\Exception $e) {
            print_r($e);
        }
        return '';
    }
}
