<?php

namespace Move\Embed\AdapterProvider;

use Move\Embed\Adapter\Oembed;
use Move\Embed\Parser\ParserInterface;
use Move\Embed\Parser\RegexParser;
use PHPUnit\Framework\TestCase;

/**
 * Class YoutubeTest
 * @package Embed\AdapterProvider
 */
class YoutubeTest extends TestCase
{
    /**
     * @return array
     */
    public function provideStrings()
    {
        $instance = new Youtube();
        $parser = $instance->getParser();

        return [
            [$parser, 'https://youtu.be/ppWbbKwBVp1', true, 'ppWbbKwBVp1'],
            [$parser, 'https://www.youtube.com/watch?v=7m_V1JG7Pr2', true, '7m_V1JG7Pr2'],
            [$parser, 'http://youtu.be/dQw4w9WgXQ3', true, 'dQw4w9WgXQ3'],
            [$parser, 'http://www.youtube.com/embed/dQw4w9WgXc4', true, 'dQw4w9WgXc4'],
            [$parser, 'http://www.youtube.com/watch?v=dQw4w9WgXc5', true, 'dQw4w9WgXc5'],
            [$parser, 'http://www.youtube.com/v/dQw4w9WgXc6', true, 'dQw4w9WgXc6'],
            [$parser, 'http://www.youtube.com/watch?feature=player_embedded&v=dQw4w9WgXc7', true, 'dQw4w9WgXc7'],

            [$parser, 'www.youtube.com/v/dQw4w9WgXc8', true, 'dQw4w9WgXc8'],
            [$parser, 'youtube.com/v/dQw4w9WgXc9', true, 'dQw4w9WgXc9'],
            [$parser, 'youtube.com/v/dQw4w9WgXcQEsdfasfgasg', true, 'dQw4w9WgXcQ'],

            [$parser, 'youtube.comyoutu.be/v/dQw4w9WgXcQ', false, ''],
        ];
    }

    /**
     * @covers Youtube::getAdapter
     */
    public function testGetAdapter()
    {
        $instance = new Youtube();
        $this->assertInstanceOf(
            Oembed::class,
            $instance->getAdapter()
        );
    }

    /**
     * @covers Youtube::getParser
     */
    public function testGetParser()
    {
        $instance = new Youtube();
        $this->assertInstanceOf(
            RegexParser::class,
            $instance->getParser()
        );
    }

    /**
     * @dataProvider provideStrings
     * @depends testGetParser
     * @param ParserInterface $parser
     * @param $string
     * @param $expectedResult
     * @param $expectedParam
     */
    public function testGetParserResult(ParserInterface $parser, $string, $expectedResult, $expectedParam)
    {
        $this->assertEquals($expectedResult, $parser->matchString($string, $param));
        if ($expectedResult) {
            $this->assertEquals($expectedParam, $param[1]);
        }
    }
}
