<?php

namespace Move\Jato\Command;

use PHPUnit\Framework\TestCase;

/**
 * Class FetchVehicleBuilderCommandTest
 * @package Move\Jato\Command
 */
class FetchVehicleBuilderCommandTest extends TestCase
{
    /**
     * @return FetchVehicleBuilderCommand
     */
    public function testConstruct() : FetchVehicleBuilderCommand
    {
        $database = 'SSCF_CS2002';
        $benchmarkVehicle = '777513320170101';
        $vehicleId = '777513320170101';
        $command = new FetchVehicleBuilderCommand($database, $benchmarkVehicle, $vehicleId);

        $databaseTest = $command->getDatabase();
        $benchmarkVehicleTest = $command->getBenchMarkVehicle();
        $vehicleIdTest = $command->getVehicleId();

        $this->assertEquals($database, $databaseTest, 'Database not equal');
        $this->assertEquals($benchmarkVehicle, $benchmarkVehicleTest, 'BenchMarkVehicle not equal');
        $this->assertEquals($vehicleId, $vehicleIdTest, 'VehicleId not equal');

        return $command;
    }

    /**
     * @depends testConstruct
     * @param FetchVehicleBuilderCommand $command
     */
    public function testGetDatabase(FetchVehicleBuilderCommand $command)
    {
        $result = $command->getDatabase();
        $this->assertInternalType('string', $result, 'Database not string');
    }

    /**
     * @depends testConstruct
     * @param FetchVehicleBuilderCommand $command
     */
    public function testGetBenchMarkVehicle(FetchVehicleBuilderCommand $command)
    {
        $result = $command->getBenchMarkVehicle();
        $this->assertInternalType('string', $result, 'BenchMarkVehicle not string');
    }

    /**
     * @depends testConstruct
     * @param FetchVehicleBuilderCommand $command
     */
    public function testGetVehicleId(FetchVehicleBuilderCommand $command)
    {
        $result = $command->getVehicleId();
        $this->assertInternalType('string', $result, 'VehicleId not string');
    }

    /**
     * @depends testConstruct
     * @param FetchVehicleBuilderCommand $command
     */
    public function testSetDatabase(FetchVehicleBuilderCommand $command)
    {
        $new = 'test';
        $command->setDatabase($new);
        $result = $command->getDatabase();

        $this->assertEquals($new, $result, 'Not set');
    }

    /**
     * @depends testConstruct
     * @param FetchVehicleBuilderCommand $command
     */
    public function testSetBenchMarkVehicle(FetchVehicleBuilderCommand $command)
    {
        $new = 'test';
        $command->setBenchMarkVehicle($new);
        $result = $command->getBenchMarkVehicle();

        $this->assertEquals($new, $result, 'Not set');
    }

    /**
     * @depends testConstruct
     * @param FetchVehicleBuilderCommand $command
     */
    public function testSetVehicleId(FetchVehicleBuilderCommand $command)
    {
        $new = 'test';
        $command->setVehicleId($new);
        $result = $command->getVehicleId();

        $this->assertEquals($new, $result, 'Not set');
    }

}