<?php


namespace Cms\Client\Service;

/**
 * Trait AddressBookServiceAwareTrait
 * @package Cms\Client\Service
 */
trait AddressBookServiceAwareTrait
{

    /** @var  \Cms\Client\Service\AddressBookService */
    protected $adrbookService;

    /**
     * @param \Cms\Client\Service\AddressBookService $adrbookService
     * @return $this
     */
    public function setAddressBookService(AddressBookService $adrbookService)
    {
        $this->adrbookService = $adrbookService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\AddressBookService
     * @throws \DomainException
     */
    public function getAddressBookService() : AddressBookService
    {
        if (!$this->adrbookService instanceof AddressBookService) {
            throw new \DomainException('adrbookService is not a AddressBookService instance');
        }
        return $this->adrbookService;
    }
}
