<?php


namespace Cms\Client\Service;

/**
 * Trait ContractServiceAwareTrait
 * @package Cms\Client\Service
 */
trait ContractServiceAwareTrait
{
    /** @var  \Cms\Client\Service\ContractService */
    protected $contractService;

    /**
     * @param \Cms\Client\Service\ContractService $contractService
     * @return $this
     */
    public function setContractService(ContractService $contractService)
    {
        $this->contractService = $contractService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\ContractService
     * @throws \DomainException
     */
    public function getContractService() : ContractService
    {
        if (!$this->contractService instanceof ContractService) {
            throw new \DomainException('contractService is not a ContractService instance');
        }
        return $this->contractService;
    }
}
