<?php


namespace Cms\Search\Geodata;

use Cms\Search\AbstractSearchClient;
use Cms\Search\GeodataIndexFactory;
use Cms\Search\SearchClientAdapterInterface;

/**
 * Class AdminSearchClient
 * @package Cms\Search\Geodata
 */
class AdminSearchClient extends AbstractSearchClient
{

    /** @var array */
    protected $sortCols = [
        'id',
    ];

    /** @var array */
    protected $defaultFields = [
        'admin_name',
    ];

    /**
     * AdminSearchClient constructor.
     * @param SearchClientAdapterInterface $searchClient
     * @param string $indexName
     */
    public function __construct(
        SearchClientAdapterInterface $searchClient,
        string $indexName = null
    ) {
        parent::__construct($searchClient);
        $this->indexName = $indexName ?? GeodataIndexFactory::INDEX_NAME;
    }

    /**
     * @return string
     */
    protected function getMappingType() : string
    {
        return AdminIndexFactory::MAPPING_NAME;
    }

    /**
     * @return array
     */
    protected function getDefaultMatchFields() : array
    {
        return $this->defaultFields;
    }
}
