<?php


namespace Cms\Serializer;

use Cms\DashParser\Entity\EntityImage;
use Cms\DashParser\Entity\EntityInterface;
use function Cms\DashParser\html_specialchars;

/**
 * Class AmpEntityImageConverter
 * @package Cms\Serializer
 */
class AmpEntityImageConverter extends HtmlEntityImageConverter
{

    /**
     * @param \DOMDocument $doc
     * @param EntityInterface $entity
     * @param null $nodeText
     * @return \DOMElement|null
     */
    public function getEntityNode(\DOMDocument $doc, EntityInterface $entity, $nodeText = null)
    {
        if (!$entity instanceof EntityImage) {
            return null;
        }

        // balise figure
        $fig = $doc->createElement('figure');
        $fig->setAttribute('class', 'visu');

        // balises image
        $imgNode = $doc->createElement('amp-img');
        $imgNode->setAttribute('alt', $entity->getLegend() ?: $nodeText);
        $imgNode->setAttribute('src', $entity->getSrc());
        $imgNode->setAttribute('layout', 'responsive');
        if ($entity->getWidth()) {
            $imgNode->setAttribute('width', $entity->getWidth());
        }
        if ($entity->getHeight()) {
            $imgNode->setAttribute('height', $entity->getHeight());
        }
        $fig->appendChild($imgNode);

        // ajout des donnée de captions
        if (!empty($entity->getLegend()) || !empty($entity->getCopy())) {
            $figCap = $doc->createElement('figcaption');
            if (!empty($entity->getLegend())) {
                $legend = $entity->getLegend();
                html_specialchars($legend);
                $span = $doc->createElement('span', $legend);
                $span->setAttribute('class', 'desc-photo');
                $figCap->appendChild($span);
            }
            if (!empty($entity->getCopy())) {
                $copy = $entity->getCopy();
                html_specialchars($copy);
                $span = $doc->createElement('span', '© ' . $copy);
                $span->setAttribute('class', 'credits-photo');
                $figCap->appendChild($span);
            }
            $fig->appendChild($figCap);
        }

        return $fig;
    }
}
