<?php

namespace Cms\Model\CmsUser;

use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class CmsUserModel
 * @package Cms\Model\CmsUser
 * @property int $id
 * @property string $show_name
 * @property string $email
 * @property string $password_hash
 * @property string $password_hash_type
 * @property string $prefs
 * @property CmsUserState $state
 * @property string $reset_passwd_key
 * @property \DateTime $reset_passwd_at
 * @property bool $reset_passwd_used
 */
class CmsUserModel extends DomainObjectAbstract
{
    use StampAwareModelTrait;

    /** @var  int */
    protected $id;

    /** @var  string */
    protected $show_name;

    /** @var  string */
    protected $email;

    /** @var  string */
    protected $password_hash;

    /** @var  string */
    protected $password_hash_type;

    /** @var  string */
    protected $prefs;

    /** @var  CmsUserState */
    protected $state = CmsUserState::ONLINE;

    /** @var  string */
    protected $reset_passwd_key;

    /** @var  \DateTime */
    protected $reset_passwd_at;

    /** @var  bool */
    protected $reset_passwd_used;
}
