<?php

namespace Move\Embed\AdapterProvider;

use Move\Embed\Adapter\Oembed;
use Move\Embed\Normalizer\YoutubeNormalizer;
use Move\Embed\Parser\RegexParser;

/**
 * Class Youtube
 * @package Embed\AdapterProvider
 */
class Youtube extends AbstractAdapterProvider
{

    /**
     * @return Oembed
     */
    public function getAdapter()
    {
        $oembed = new Oembed('http://www.youtube.com/oembed');
        $oembed->setNormalizer(new YoutubeNormalizer($this->getParser()));
        return $oembed;
    }

    /**
     * @inheritdoc
     *
     * URLs compatibles :
     *  - https://youtu.be/ppWbbKwBVpw
     *  - https://www.youtube.com/watch?v=7m_V1JG7PrA
     *  - http://youtu.be/dQw4w9WgXcQ
     *  - http://www.youtube.com/embed/dQw4w9WgXcQ
     *  - http://www.youtube.com/watch?v=dQw4w9WgXcQ
     *  - http://www.youtube.com/v/dQw4w9WgXcQ
     *  - http://www.youtube.com/watch?feature=player_embedded&v=dQw4w9WgXcQ
     */
    public function getParser()
    {
        // source: http://stackoverflow.com/a/10524505
        $pattern = '@^(?:https?://)?';        # Optional URL scheme. Either http or https.
        $pattern .= '(?:www\.)?';            #  Optional www subdomain.
        $pattern .= '(?:';                    #  Group host alternatives:
        $pattern .= 'youtu\.be/';        #    Either youtu.be,
        $pattern .= '|youtube\.com';        #    or youtube.com
        $pattern .= '(?:';                #    Group path alternatives:
        $pattern .= '/embed/';                #      Either /embed/,
        $pattern .= '|/v/';                #      or /v/,
        $pattern .= '|/watch\?v=';            #      or /watch?v=,
        $pattern .= '|/watch\?[^&]+&v=';        #      or /watch?other_param&v=
        $pattern .= ')';                    #    End path alternatives.
        $pattern .= ')';                    #  End host alternatives.
        $pattern .= '([\w-]{11})';            # 11 characters (Length of Youtube video ids).
        $pattern .= '(?:.+)?$@';            # Optional other ending URL parameters.
        return new RegexParser($pattern);
    }
}
