<?php


namespace Move\Http\Strategy\Handler;

use Move\Http\Strategy\ExceptionHandler\ExceptionHandler;
use Move\Http\Strategy\ExceptionHandler\ExceptionHandlerInterface;
use Move\Http\Strategy\Serializer\SerializerInterface;
use Move\Specification\Specification;

/**
 * Class HandlerServiceAbstract
 * @package Move\Http\Strategy\Handler
 */
abstract class HandlerServiceAbstract extends Specification
{

    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ExceptionHandlerInterface
     */
    private $exceptionHandler;

    /**
     * JsonHandlerService constructor.
     * @param SerializerInterface $serializer
     * @param ExceptionHandlerInterface $exceptionHandler
     */
    public function __construct(
        SerializerInterface $serializer,
        ExceptionHandlerInterface $exceptionHandler = null
    ) {
        $this->serializer = $serializer;
        $this->exceptionHandler = $exceptionHandler ?: new ExceptionHandler();
    }

    /**
     * @param \Exception $exception
     * @return mixed
     */
    public function handleException(\Exception $exception)
    {
        return $this->exceptionHandler->handle($exception);
    }

    /**
     * @param SerializerInterface $serializer
     * @return $this
     */
    public function setSerializer(SerializerInterface $serializer)
    {
        $this->serializer = $serializer;
        return $this;
    }

    /**
     * @param ExceptionHandlerInterface $exceptionHandler
     * @return $this
     */
    public function setExceptionHandler(ExceptionHandlerInterface $exceptionHandler)
    {
        $this->exceptionHandler = $exceptionHandler;
        return $this;
    }

    /**
     * @return ExceptionHandlerInterface
     */
    public function getExceptionHandler()
    {
        return $this->exceptionHandler;
    }

    /**
     * @return SerializerInterface
     */
    public function getSerializer()
    {
        return $this->serializer;
    }
}
