<?php


namespace Cms\Client\AddressBook;

use Cms\Client\ClientIndexQueryBuilder;

/**
 * Class AddressBookAddressClientQueryBuilder
 * @package Cms\Client\AddressBook
 */
class AddressBookAddressClientQueryBuilder extends ClientIndexQueryBuilder
{

    /**
     * @param string $search
     * @return $this
     */
    public function setSearch($search)
    {
        return $this->setFilter('search', $search);
    }

    /**
     * @param string $countryCode
     * @return $this
     */
    public function setExcludeCountry($countryCode)
    {
        return $this->setFilter('exclude_country', (string)$countryCode);
    }

    /**
     * @param string $adminCode
     * @param int $level
     * @return $this
     */
    public function setAdminCode($adminCode, $level)
    {
        return $this->setFilter('admin' . $level . '_code', (string)$adminCode);
    }

    /**
     * @param string $countryCode
     * @return $this
     */
    public function setCountry($countryCode)
    {
        return $this->setFilter('country', (string)$countryCode);
    }

    /**
     * @param int|array $categoryId
     * @return $this
     */
    public function setCategoryId($categoryId)
    {
        return $this->setFilter('category_id', $categoryId);
    }

    /**
     * @param int $bookId
     * @return $this
     */
    public function setBookId($bookId)
    {
        return $this->setFilter('book_id', $bookId);
    }

    /**
     * @param string $name
     * @param string $value
     * @return $this
     */
    public function setAttribute($name, $value)
    {
        return $this->setFilter('attributes', [
            $name => $value,
        ]);
    }
}
