<?php

namespace Cms\Client\Asset;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Model\Asset\Tag\TagModel;

/**
 * Class AssetTagClient
 * @package Cms\Client\Asset
 */
class AssetTagClient extends AbstractClient
{
    /** @var string */
    protected $basePath = 'asset/tag';

    /**
     * @param array $dataset
     * @return TagModel
     */
    public function handleData($dataset = [])
    {
        return (new TagModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return TagModel[]|CmsApiIndexIterator
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpServerException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param null|int $scope
     * @param int $page
     * @return TagModel[]|CmsApiIndexIterator
     */
    public function getIndex($scope = null, $page = 0)
    {
        $result = $this->getBuilder()->setFilter('scope', $scope);
        return $result->getIndex($page);
    }

    /**
     * @param TagModel $object
     * @return bool|TagModel
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function updateItem(TagModel $object)
    {
        return $this->saveItem($object);
    }

    /**
     * @param TagModel $object
     * @return bool|TagModel
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function createItem(TagModel $object)
    {
        return $this->saveItem($object);
    }
}
