<?php

namespace Cms\Client\Command\Member\Command;

use Cms\Client\Command\ScopeFilterAwareTrait;

/**
 * Class SetNewsletterCommand
 * @package Cms\Client\Command\Member\Command
 */
class SetNewsletterCommand
{
    use ScopeFilterAwareTrait;

    /** @var string */
    private $email;

    /** @var null|bool */
    private $info;

    /** @var null|bool */
    private $partner;

    /** @var null|string */
    private $rewardSource;

    /** @var null|string */
    private $rewardCampaign;

    /**
     * SetNewsletterCommand constructor.
     * @param int $scopeId
     * @param string $email
     * @param null|bool $info
     * @param null|bool $partner
     * @param string|null $rewardSource
     * @param string|null $rewardCampaign
     */
    public function __construct(
        $scopeId,
        string $email,
        bool $info = null,
        bool $partner = null,
        string $rewardSource = null,
        string $rewardCampaign = null
    ) {
        $this->scope_id = $scopeId;
        $this->email = $email;
        $this->info = $info;
        $this->partner = $partner;
        $this->rewardSource = $rewardSource;
        $this->rewardCampaign = $rewardCampaign;
    }

    /**
     * @param string $email
     * @return SetNewsletterCommand
     */
    public function setEmail(string $email) : SetNewsletterCommand
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @param bool|null $info
     * @return SetNewsletterCommand
     */
    public function setInfo(?bool $info) : SetNewsletterCommand
    {
        $this->info = $info;
        return $this;
    }

    /**
     * @param bool|null $partner
     * @return SetNewsletterCommand
     */
    public function setPartner(?bool $partner) : SetNewsletterCommand
    {
        $this->partner = $partner;
        return $this;
    }

    /**
     * @param null|string $rewardSource
     * @return SetNewsletterCommand
     */
    public function setRewardSource(?string $rewardSource) : SetNewsletterCommand
    {
        $this->rewardSource = $rewardSource;
        return $this;
    }

    /**
     * @param null|string $rewardCampaign
     * @return SetNewsletterCommand
     */
    public function setRewardCampaign(?string $rewardCampaign) : SetNewsletterCommand
    {
        $this->rewardCampaign = $rewardCampaign;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail() : string
    {
        return $this->email;
    }

    /**
     * @return null|bool
     */
    public function isInfo() :?bool
    {
        return $this->info;
    }

    /**
     * @return null|bool
     */
    public function isPartner() :?bool
    {
        return $this->partner;
    }

    /**
     * @return null|string
     */
    public function getRewardSource() : ?string
    {
        return $this->rewardSource;
    }

    /**
     * @return null|string
     */
    public function getRewardCampaign() : ?string
    {
        return $this->rewardCampaign;
    }
}
