<?php

namespace Cms\Extension\MediaHandler;

use Cms\Client\AssetConfigRelationRestfulModel;
use Move\Command\Chain\AbstractHandler;

/**
 * Class AbstractMediaHandler
 * @package Cms\Extension\MediaHandler
 */
abstract class AbstractMediaHandler extends AbstractHandler implements MediaHandlerInterface
{

    /** @var array */
    protected $provides = [];

    /**
     * @param AssetConfigRelationRestfulModel $assetModel
     * @param array $handlerConfig
     * @return string
     */
    abstract protected function renderMedia(
        AssetConfigRelationRestfulModel $assetModel,
        array $handlerConfig = []
    );

    /**
     * @param AssetConfigRelationRestfulModel $relationRestfulModel
     * @return bool
     * @throws \UnexpectedValueException
     */
    protected function canHandle(AssetConfigRelationRestfulModel $relationRestfulModel)
    {
        if (!\is_array($this->provides)) {
            throw new \UnexpectedValueException('provides is invalid');
        }
        return $relationRestfulModel
            && \in_array((string)$relationRestfulModel->asset_profil, $this->provides);
    }

    /**
     * Processes the request.
     * This is the only method a child can implements,
     * with the constraint to return null to dispatch the request to next successor.
     * @param $request
     * @return null|mixed
     * @throws \InvalidArgumentException
     */
    protected function process($request)
    {
        if (!$request instanceof MediaHandlerRequest) {
            throw new \InvalidArgumentException('request must be an AssetHandlerResquest instance');
        }

        $assetRelationModel = $request->getAssetRelationModel();
        $handlerConfig = $request->getHandlerConfig();

        if ($this->canHandle($assetRelationModel) === true) {
            if (!empty($handlerConfig[(string)$assetRelationModel->asset_profil])) {
                $handlerConfig = $handlerConfig[(string)$assetRelationModel->asset_profil];
            }

            return $this->renderMedia($assetRelationModel, $handlerConfig);
        }
        return null;
    }
}
