<?php

namespace Cms\Extension\TemplateBloc\Decorator;

use Cms\Client\Article\Model\CategoryRestfulModel;
use Cms\Decorator\DomainObjectDecoratorInterface;
use Move\ObjectMapper\ObjectTransformer;
use POM\DomainObjectInterface;

/**
 * Class ArticleCategoryArrayDecorator
 * @package Cms\Extension\TemplateBloc\Decorator
 */
class ArticleCategoryArrayDecorator implements DomainObjectDecoratorInterface
{

    /** @var ObjectTransformer */
    private $categoryTransformer;

    /**
     * ArticleCategoryArrayDecorator constructor.
     * @param ObjectTransformer $categoryTransformer
     */
    public function __construct(ObjectTransformer $categoryTransformer = null)
    {
        $this->categoryTransformer = $categoryTransformer ?: new ObjectTransformer();
    }

    /**
     * @param DomainObjectInterface $object
     * @param mixed $command
     * @return mixed
     */
    public function decorate(DomainObjectInterface $object, $command)
    {
        if (!\is_array($command) && !empty($command)) {
            return $command;
        }

        if (!empty($object) && $object instanceof CategoryRestfulModel) {
            $command['category'] = $this->categoryTransformer->transform($object);
        }
        return $command;
    }
}
