<?php

namespace Cms\Search\Provider\Elastica;

use Cms\Search\SearchClientAdapterAwareInterface;
use Cms\Search\SearchClientAdapterInterface;
use Elastica\Client;
use League\Container\Argument\RawArgument;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;

/**
 * Class SearchProvider
 * @package Cms\Search\Provider\Elastica
 */
class ElasticaSearchProvider extends AbstractServiceProvider implements BootableServiceProviderInterface
{

    /** @var array */
    private $servers;

    /** @var array */
    protected $provides = [
        Client::class,
        SearchClientAdapterInterface::class,
    ];

    /**
     * SearchProvider constructor.
     * @param array $servers
     */
    public function __construct(array $servers)
    {
        $this->servers = $servers;
    }

    /**
     * @inheritdoc
     * @throws \Psr\Container\ContainerExceptionInterface
     * @throws \InvalidArgumentException
     * @throws \League\Flysystem\FileNotFoundException
     * @throws \Psr\Cache\InvalidArgumentException
     * @throws \RuntimeException
     * @throws \Psr\Container\NotFoundExceptionInterface
     */
    public function register()
    {
        // récupertion du client
        $this->container->share(Client::class)
            ->withArguments([
                new RawArgument($this->servers),
                new RawArgument(null),
                //LoggerInterface::class,
            ]);

        // creation de l'adapter elastica
        $this->container->add(SearchClientAdapterInterface::class, ElasticSearchAdapter::class)
            ->withArguments([
                Client::class,
            ]);
    }

    /**
     * @inheritdoc
     */
    public function boot()
    {
        $this->container->inflector(SearchClientAdapterAwareInterface::class)
            ->invokeMethod('setSearchClient', [
                SearchClientAdapterInterface::class,
            ]);
    }
}
