<?php

namespace Move\Http\Middleware;

use Psr\Http\Message\ServerRequestInterface;

/**
 * Class PathInfoMiddleware
 * @package Move\Http\Middleware
 */
class PathInfoMiddleware implements MiddlewareInterface
{

    /**
     * @param ServerRequestInterface $request
     * @return ServerRequestInterface
     */
    public function __invoke(ServerRequestInterface $request)
    {
        return $this->handle($request);
    }

    /**
     * Handle the payload.
     * @param ServerRequestInterface $request
     * @return ServerRequestInterface
     */
    public function handle(ServerRequestInterface $request)
    {
        $serverParams = $request->getServerParams();
        if (!empty($serverParams['PATH_INFO'])) {
            $uri = $request->getUri()->withPath($serverParams['PATH_INFO']);
            $request = $request->withUri($uri);
        }
        return $request;
    }
}
