<?php


namespace Move\Http\Route;

/**
 * Interface RouterAdapterInterface
 * @package Move\Http\Route
 */
interface RouterAdapterInterface
{

    /**
     * Lance la creation de route via les provider de route
     * @param string[]|AbstractRouteProvider[] $providers
     */
    public function delegate(array $providers);

    /**
     * @param array|string $method
     * @param string $path
     * @param string $handler
     * @return mixed
     */
    public function map($method, $path, $handler);

    /**
     * @param string $prefixUrl
     * @param array $routeList
     * @return mixed
     */
    public function group($prefixUrl, array $routeList = []);
}
