<?php


namespace Move\Http\Strategy\DataContainer;

/**
 * Class EngineDataContainer
 * @package Move\Http\Strategy\DataContainer
 */
class EngineDataContainer extends DataContainer
{

    /**
     * @var mixed
     */
    private $template;

    /**
     * EngineDataContainer constructor.
     * @param mixed $template
     * @param array $dataset
     */
    public function __construct($template, array $dataset = [])
    {
        parent::__construct($dataset);
        $this->template = $template;
    }


    /**
     * @inheritdoc
     */
    public function offsetExists($offset)
    {
        return \in_array($offset, ['data', 'template'], true);
    }


    /**
     * @inheritdoc
     */
    public function offsetGet($offset)
    {
        switch ($offset) {
            case 'data':
                return $this->getDataset();
                break;
            case 'template':
                return $this->getTemplate();
                break;
        }
        return null;
    }


    /**
     * @inheritdoc
     */
    public function offsetSet($offset, $value)
    {
        switch ($offset) {
            case 'data':
                $this->setDataset($value);
                break;
            case 'template':
                $this->setTemplate($value);
                break;
        }
    }

    /**
     * @return mixed
     */
    public function getTemplate()
    {
        return $this->template;
    }

    /**
     * @param mixed $template
     */
    public function setTemplate($template)
    {
        $this->template = $template;
    }
}
