<?php

namespace Move\Command\Command;

use PHPUnit\Framework\TestCase;

/**
 * Class DeleteCommandTest
 */
class DeleteCommandTest extends TestCase
{

    public function provideDryRun()
    {
        return [
            'with DryRun' => [true,],
            'without DryRun' => [false,]
        ];
    }

    public function provideId()
    {
        return [
            [1234,],
            [12356,]
        ];
    }

    /**
     * @dataProvider provideId
     * @param int $id
     * @return DeleteCommand
     */
    public function testConstructCommand($id)
    {
        $command = new DeleteCommand($id);
        $this->assertEquals($id, $command->getId());
        $this->assertFalse($command->isDryRun());

        return $command;
    }

    /**
     * @dataProvider provideDryRun
     * @param bool $isDryRun
     */
    public function testWithDryRun(bool $isDryRun)
    {
        $command = new DeleteCommand(null);
        $this->assertFalse($command->isDryRun());
        $this->assertNotSame($command, $dryRunCmd = $command->withDryRun($isDryRun));
        $this->assertEquals($isDryRun, $dryRunCmd->isDryRun());
    }

    /**
     * @dataProvider provideId
     * @param $id
     */
    public function testWithId($id)
    {
        $command = new DeleteCommand(null);
        $this->assertNull($command->getId());
        $this->assertNotSame($command, $idCmd = $command->withId($id));
        $this->assertEquals($id, $idCmd->getId());
    }
}