<?php

namespace Move\Embed\AdapterProvider;

use Move\Embed\Adapter\Digiteka as DigitekaAdapter;
use Move\Embed\Parser\ParserInterface;
use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

/**
 * Class DigitekaTest
 * @package Move\Embed\AdapterProvider
 */
class DigitekaTest extends TestCase
{
    /**
     * @return array
     */
    public function provideStrings()
    {
        $instance = new Digiteka();
        $parser = $instance->getParser();
        return [
            [$parser, 'https://www.ultimedia.com/default/index/videogeneric/id/123', true, '123'],
            [$parser, 'www.ultimedia.com/default/index/videogeneric/id/124', true, '124'],
            [$parser, 'ultimedia.com/default/index/videogeneric/id/125', true, '125'],

            [$parser, 'ultimedia.com/default/index/videogeneric/id//', false, ''],
            [$parser, 'https://www.google.com/default/index/videogeneric/id/126', false, ''],
        ];
    }

    /**
     * @covers Digiteka::__construct
     */
    public function testConstruct()
    {
        $mdtk = '12345';
        $instance = new Digiteka($mdtk);

        $this->assertInstanceOf(Digiteka::class, $instance);
        $this->assertEquals(
            $mdtk,
            Reflection::getValue($instance, 'mdtk')
        );
        return $instance;
    }

    /**
     * @depends testConstruct
     * @param Digiteka $instance\
     */
    public function testGetAdapter(Digiteka $instance)
    {
        $adapter = $instance->getAdapter();
        $this->assertInstanceOf(DigitekaAdapter::class, $adapter);
    }

    /**
     * @depends testConstruct
     * @expectedException \UnexpectedValueException
     */
    public function testGetAdapterWithException()
    {
        $instance = new Digiteka();
        $instance->getAdapter();
    }

    /**
     * @depends testConstruct
     */
    public function testGetParser()
    {
        $instance = new Digiteka();
        $parser = $instance->getParser();
        $this->assertInstanceOf(ParserInterface::class, $parser);
    }

    /**
     * @dataProvider provideStrings
     * @depends testGetParser
     * @param ParserInterface $parser
     * @param string $str
     * @param $expectedResult
     * @param $expectedParam
     */
    public function testGetParserResult(ParserInterface $parser, string $str, $expectedResult, $expectedParam)
    {
        $this->assertEquals($expectedResult, $parser->matchString($str, $param));
        if ($expectedResult) {
            $this->assertEquals($expectedParam, $param[1]);
        }
    }
}
