<?php

namespace Cms\Client\Article;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Model\Article\Tag\TagModel;

/**
 * Class ArticleTagClient
 * @package Cms\Client\Article
 */
class ArticleTagClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'article/tag';

    /**
     * @param array $dataset
     * @return TagModel
     */
    public function handleData($dataset = [])
    {
        return (new TagModel())->populate($dataset);
    }

    /**
     * @param array $queryParams
     * @return TagModel[]|CmsApiIndexIterator
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param int $page
     * @return TagModel[]|CmsApiIndexIterator
     */
    public function getIndex($page = 0)
    {
        $results = $this->getBuilder()
            ->getIndex($page);
        return $results;
    }
}
