<?php


namespace Cms\LinkResource\Provider\CMS;

use Cms\LinkResource\LinkResourceType;
use Cms\LinkResource\Provider\AbstractDelegateDataAdapter;
use Cms\Model\Member\MemberModel;
use POM\DomainObjectInterface;

/**
 * Class AbstractCmsMemberProvider
 * @package Cms\LinkResource\Provider\CMS
 */
abstract class AbstractCmsMemberProvider extends AbstractDelegateDataAdapter
{

    /** @var array */
    protected $types = [
        LinkResourceType::MEMBER,
    ];

    /**
     * @inheritdoc
     */
    public function getLabelFromModel(DomainObjectInterface $model)
    {
        if ($model instanceof MemberModel) {
            return $model->firstname || $model->lastname
                ? $model->firstname . ' ' . $model->lastname . ' (' . $model->email . ')'
                : $model->email;
        }
        return null;
    }
}
