<?php

namespace Cms\LinkResource\Provider;

use Cms\LinkResource\LinkResourceType;

/**
 * Interface DataAdapterAwareInterface
 * @package Cms\LinkResource\Provider
 */
interface DataAdapterAwareInterface
{

    /**
     * @param LinkResourceType|string $typeCode
     * @param int $objectId
     * @return mixed
     */
    public function getData($typeCode, $objectId);

    /**
     * @param LinkResourceType|string $typeCode
     * @param int $objectId
     * @return string|null
     */
    public function getLabel($typeCode, $objectId);
}
