<?php

namespace Move\Command;

/**
 * Interface CommandBusAwareTrait
 * @package Move\Command
 */
trait CommandBusAwareTrait
{

    /** @var CommandBusInterface */
    protected $commandBus;

    /**
     * @return CommandBusInterface
     */
    public function getCommandBus() : CommandBusInterface
    {
        if (!$this->commandBus instanceof CommandBusInterface) {
            throw new \UnexpectedValueException('commandBus is not defined properly');
        }

        return $this->commandBus;
    }

    /**
     * @param CommandBusInterface $commandBus
     * @return $this
     */
    public function setCommandBus(CommandBusInterface $commandBus)
    {
        $this->commandBus = $commandBus;

        return $this;
    }
}
