<?php

namespace Move\Specification;

/**
 * Class BirthdateSpecification
 * @package Move\Specification
 */
class BirthdateSpecification extends Specification
{
    /**
     * @var string
     */
    private $entryFormat;

    /**
     * @var int
     */
    private $minAge;

    /**
     * PatternSpecification constructor.
     * @param string $entryFormat
     * @param int $minAge
     */
    public function __construct($entryFormat = 'd/m/Y', $minAge = 0)
    {
        $this->entryFormat = $entryFormat;
        $this->minAge = $minAge;
    }

    /**
     * @param mixed $object
     * @return bool
     */
    public function isSatisfiedBy($object) : bool
    {
        if (\is_string($object)) {
            $birthdate = \DateTime::createFromFormat($this->entryFormat, $object);
            $today = new \DateTime('now');
            $interval = $birthdate->diff($today);
            $nbYears = $interval->format('%r%y');
            if ($nbYears <= 110 && $nbYears >= $this->minAge) {
                return true;
            }
        }
        return false;
    }
}
