<?php

namespace Cms\Client\Article;

use Cms\Client\AbstractClient;
use Cms\Client\Article\Model\CategoryRestfulModel;
use Cms\Client\CmsApiIndexIterator;
use Cms\Model\Article\Category\CategoryModel;
use Move\Utils\Str;
use POM\DomainObjectInterface;

/**
 * Class CategoryClient
 * @package Cms\Client\Article
 */
class CategoryClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'article/category';

    /**
     * @param array $dataset
     * @return DomainObjectInterface
     */
    public function handleData($dataset = [])
    {
        return (new CategoryRestfulModel())->populate($dataset, true);
    }

    /**
     * @return CategoryClientQueryBuilder
     */
    public function getBuilder()
    {
        $builder = new CategoryClientQueryBuilder($this);
        return $builder;
    }


    /**
     * @param array $queryParams
     * @return CategoryRestfulModel[]|CmsApiIndexIterator
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param int $scope
     * @param int $page
     * @return CategoryRestfulModel[]|CmsApiIndexIterator
     */
    public function getIndex($scope, $page = 0)
    {
        $results = $this->getBuilder()
            ->setScope($scope)
            ->getIndex($page);
        return $results;
    }

    /**
     * @param int $parentId
     * @param int $page
     * @return CategoryRestfulModel[]|CmsApiIndexIterator
     */
    public function getIndexByParentId($parentId, $page = 0)
    {
        $results = $this->getBuilder()
            ->setParentId($parentId)
            ->getIndex($page);
        return $results;
    }

    /**
     * @param string $search
     * @param null|int $scopeId
     * @return CategoryRestfulModel[]|CmsApiIndexIterator
     */
    public function getIndexBySearch($search, $scopeId = null)
    {
        $results = $this->getBuilder()
            ->setScope($scopeId)
            ->setSearch($search)
            ->getIndex(-1);
        return $results;
    }

    /**
     * @param string $slug
     * @param int $scope
     * @param int $slugLevel
     * @param string|null $langage
     * @return \Cms\Client\Article\Model\CategoryRestfulModel|null
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     */
    public function fetchItemBySlug($slug, $scope, $slugLevel = 0, string $langage = null)
    {
        $object = $this->fetchItem(
            Str::toAscii($slug),
            [
                'scope'      => $scope,
                'slug_level' => $slugLevel,
                'language'   => $langage,
            ]
        );
        return $object;
    }

    /**
     * @param $scope
     * @param array $slugs
     * @param int $slugLevel
     * @return array
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \RuntimeException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function fetchItemsBySlugs($scope, array $slugs = [], $slugLevel = -1): array
    {
        return parent::fetchBulkItems($slugs, [
            'scope'      => $scope,
            'slug_level' => $slugLevel,
        ]);
    }

    /**
     * @param CategoryModel $object
     * @return CategoryModel|CategoryRestfulModel|null
     * @throws \LogicException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \InvalidArgumentException
     */
    public function updateItem(CategoryModel $object)
    {
        $object = $this->updateObjectFromClient($object, 'article/category');
        return $object;
    }

    /**
     * @param CategoryModel $object
     * @return bool|CategoryModel|CategoryRestfulModel
     * @throws \LogicException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \InvalidArgumentException
     */
    public function createItem(CategoryModel $object)
    {
        $object = $this->createObjectFromClient($object, 'article/category');
        return $object;
    }
}
