<?php


namespace Cms\Client\Contract;

use Cms\Client\ClientIndexQueryBuilder;
use Cms\LinkResource\LinkResourceType;
use Cms\Model\Contract\Product\ProductProfile;

/**
 * Class ContractClientQueryBuilder
 * @package Cms\Client\Contract
 */
class ContractClientQueryBuilder extends ClientIndexQueryBuilder
{
    /**
     * @param $scopeId
     * @return $this
     */
    public function setScopeId($scopeId)
    {
        return $this->setFilter('scope_id', $scopeId);
    }

    /**
     * @param \DateTime $beginAt
     * @return $this
     */
    public function setBeginAt(\DateTime $beginAt)
    {
        return $this->setFilter('begin_at', $beginAt->getTimestamp());
    }

    /**
     * @param \DateTime $endAt
     * @return $this
     */
    public function setEndAt(\DateTime $endAt)
    {
        return $this->setFilter('end_at', $endAt->getTimestamp());
    }

    /**
     * @param bool $isActiv
     * @return $this
     */
    public function isActiv(bool $isActiv)
    {
        return $this->setFilter('is_activ', $isActiv);
    }

    /**
     * @param string $productProfile
     * @return $this
     * @throws \InvalidArgumentException
     */
    public function setProductProfile(string $productProfile)
    {
        if (!ProductProfile::isValid($productProfile)) {
            throw new \InvalidArgumentException('product profile is not a valid ProductProfile');
        }
        return $this->setFilter('product_profile', $productProfile);
    }

    /**
     * @param string|\Cms\LinkResource\LinkResourceType $type
     * @param mixed $ref
     * @return $this
     * @throws \InvalidArgumentException
     */
    public function setAdvertiser($type, $ref)
    {
        if (!LinkResourceType::isValid((string)$type)) {
            throw new \InvalidArgumentException('advertiser_type is not a valid LinkResourceType');
        }
        return $this
            ->setFilter('advertiser_type', (string)$type)
            ->setFilter('advertiser_ref', $ref);
    }

    /**
     * @param string|\Cms\LinkResource\LinkResourceType $type
     * @param mixed $ref
     * @return $this
     * @throws \InvalidArgumentException
     */
    public function setProductResource($type, $ref)
    {
        if (!LinkResourceType::isValid((string)$type)) {
            throw new \InvalidArgumentException('product_resource_type is not a valid LinkResourceType');
        }
        return $this
            ->setFilter('product_resource_type', (string)$type)
            ->setFilter('product_resource_ref', $ref);
    }
}
