<?php

namespace Move\Filter\Validator;

use Move\Filter\Filter;

/**
 * Class AbstractDomainObjectStateValidator
 * @package Move\Filter\Validator
 */
abstract class AbstractDomainObjectStateValidator extends DomainObjectStateValidator
{

    /**
     * AbstractDomainObjectStateValidator constructor.
     * @param Filter $filter
     */
    public function __construct(Filter $filter = null)
    {
        // filtre du model
        $myFilter = $this->createFilter();
        if (!$myFilter instanceof Filter) {
            throw new \UnexpectedValueException('initFilter must return a valid Filter object');
        }

        // ajoute les filtre du model
        $myFilter = $filter ? $filter->pipe($myFilter) : $myFilter;

        parent::__construct($myFilter);
    }

    /**
     * @return Filter
     */
    abstract protected function createFilter();
}
