<?php

namespace Move\Jato\Command;

use PHPUnit\Framework\TestCase;

/**
 * Class FetchAllVehicleCommandTest
 * @package Move\Jato\Command
 */
class FetchAllVehicleCommandTest extends TestCase
{
    /**
     * @return FetchAllVehicleCommand
     */
    public function testConstruct() : FetchAllVehicleCommand
    {
        $database = 'SSCF_CS2002';
        $makeKey = 'Aston Martin';
        $modelKey = 'DB11';
        $modelYear = '2017';
        $doorNumber = '2';
        $bodyCode = 'CO';
        $drivenWheels = 'R';

        $command = new FetchAllVehicleCommand(
            $database, $makeKey, $modelKey, $modelYear, $doorNumber, $bodyCode, $drivenWheels
        );

        $databaseTest = $command->getDatabase();
        $makeKeyTest = $command->getMakeKey();
        $modelKeyTest = $command->getModelKey();
        $modelYearTest = $command->getModelYear();
        $doorNumberTest = $command->getDoorNumber();
        $bodyCodeTest = $command->getBodyCode();
        $drivenWheelsTest = $command->getDrivenWheels();

        $this->assertEquals($database, $databaseTest, 'Database not equal');
        $this->assertEquals($makeKey, $makeKeyTest, 'MakeKey not equal');
        $this->assertEquals($modelKey, $modelKeyTest, 'ModelKey not equal');
        $this->assertEquals($modelYear, $modelYearTest, 'ModelYear not equal');
        $this->assertEquals($doorNumber, $doorNumberTest, 'DoorNumber not equal');
        $this->assertEquals($bodyCode, $bodyCodeTest, 'BodyCode not equal');
        $this->assertEquals($drivenWheels, $drivenWheelsTest, 'DrivenWheels not equal');

        return $command;
    }

    /**
     * @depends testConstruct
     * @param FetchAllVehicleCommand $command
     */
    public function testGetMakeKey(FetchAllVehicleCommand $command)
    {
        $result = $command->getMakeKey();
        $this->assertInternalType('string', $result, 'MakeKey not a string');
    }

    /**
     * @depends testConstruct
     * @param FetchAllVehicleCommand $command
     */
    public function testGetModelKey(FetchAllVehicleCommand $command)
    {
        $result = $command->getModelKey();
        $this->assertInternalType('string', $result, 'ModelKey not a string');
    }

    /**
     * @depends testConstruct
     * @param FetchAllVehicleCommand $command
     */
    public function testGetModelYear(FetchAllVehicleCommand $command)
    {
        $result = $command->getModelYear();
        $this->assertInternalType('string', $result, 'ModelYear not a string');
    }

    /**
     * @depends testConstruct
     * @param FetchAllVehicleCommand $command
     */
    public function testGetDoorNumber(FetchAllVehicleCommand $command)
    {
        $result = $command->getDoorNumber();
        $this->assertInternalType('string', $result, 'DoorNumber not a string');
    }

    /**
     * @depends testConstruct
     * @param FetchAllVehicleCommand $command
     */
    public function testGetBodyCode(FetchAllVehicleCommand $command)
    {
        $result = $command->getBodyCode();
        $this->assertInternalType('string', $result, 'BodyCode not a string');
    }

    /**
     * @depends testConstruct
     * @param FetchAllVehicleCommand $command
     */
    public function testGetDrivenWheels(FetchAllVehicleCommand $command)
    {
        $result = $command->getDrivenWheels();
        $this->assertInternalType('string', $result, 'DrivenWheels not a string');
    }

    /**
     * @depends testConstruct
     * @param FetchAllVehicleCommand $command
     */
    public function testSetMakeKey(FetchAllVehicleCommand $command)
    {
        $new = 'test';
        $command->setMakeKey($new);
        $result = $command->getMakeKey();

        $this->assertEquals($new, $result, 'Not set');
    }

    /**
     * @depends testConstruct
     * @param FetchAllVehicleCommand $command
     */
    public function testSetModelKey(FetchAllVehicleCommand $command)
    {
        $new = 'test';
        $command->setModelKey($new);
        $result = $command->getModelKey();

        $this->assertEquals($new, $result, 'Not set');
    }

    /**
     * @depends testConstruct
     * @param FetchAllVehicleCommand $command
     */
    public function testSetModelYear(FetchAllVehicleCommand $command)
    {
        $new = 'test';
        $command->setModelYear($new);
        $result = $command->getModelYear();

        $this->assertEquals($new, $result, 'Not set');
    }

    /**
     * @depends testConstruct
     * @param FetchAllVehicleCommand $command
     */
    public function testSetDoorNumber(FetchAllVehicleCommand $command)
    {
        $new = 'test';
        $command->setDoorNumber($new);
        $result = $command->getDoorNumber();

        $this->assertEquals($new, $result, 'Not set');
    }

    /**
     * @depends testConstruct
     * @param FetchAllVehicleCommand $command
     */
    public function testSetBodyCode(FetchAllVehicleCommand $command)
    {
        $new = 'test';
        $command->setBodyCode($new);
        $result = $command->getBodyCode();

        $this->assertEquals($new, $result, 'Not set');
    }

    /**
     * @depends testConstruct
     * @param FetchAllVehicleCommand $command
     */
    public function testSetDrivenWheels(FetchAllVehicleCommand $command)
    {
        $new = 'test';
        $command->setDrivenWheels($new);
        $result = $command->getDrivenWheels();

        $this->assertEquals($new, $result, 'Not set');
    }

}