<?php

namespace Cms\Client\Service;

use Cms\Client\CmsHttpClientInterface;
use Cms\Client\Version\VersionClient;
use League\Container\ServiceProvider\AbstractServiceProvider;

/**
 * Class VersionProvider
 * @package Cms\Client\Service
 */
class VersionProvider extends AbstractServiceProvider
{
    /** @var array */
    protected $provides = [
        VersionService::class,
        VersionClient::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        // add clients
        $this->getContainer()->add(VersionClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add service
        $this->container->add(VersionService::class)
            ->withArgument(VersionClient::class);
    }
}
