<?php

namespace Cms\Extension;

use Cms\Route\UrlBuilder;
use League\Plates\Engine;
use League\Plates\Extension\ExtensionInterface;

/**
 * Class UrlExtension
 * @package Cms\Extension
 */
class UrlExtension implements ExtensionInterface
{
    /**
     * @var \Cms\Route\UrlBuilder
     */
    private $builder;

    /** @var string */
    private $host;

    /** @var null|string */
    private $scheme;

    /**
     * UrlExtension constructor.
     * @param \Cms\Route\UrlBuilder $builder
     * @param string $host
     * @param string $scheme
     */
    public function __construct(
        UrlBuilder $builder,
        $host = null,
        $scheme = null
    ) {
        $this->builder = $builder;
        $this->host = $host;
        $this->scheme = $scheme;
    }

    /**
     * @param Engine $engine
     */
    public function register(Engine $engine)
    {
        if (!$engine->doesFunctionExist('url')) {
            $engine->registerFunction('url', [$this, 'buildUrl']);
        }
        if (!$engine->doesFunctionExist('abs_url')) {
            $engine->registerFunction('abs_url', [$this, 'buildAbsoluteUrl']);
        }
        if (!$engine->doesFunctionExist('to_abs_url')) {
            $engine->registerFunction('to_abs_url', [$this, 'urlToAbsolute']);
        }
        if (!$engine->doesFunctionExist('url_add_params')) {
            $engine->registerFunction('url_add_params', [$this, 'urlAddQueryParams']);
        }
    }

    /**
     * @param string $currentUrl
     * @param string|array $params
     * @return string
     * @throws \InvalidArgumentException
     */
    public function urlAddQueryParams(string $currentUrl, $params) : string
    {
        return $this->builder->addQueryParams($currentUrl, $params);
    }

    /**
     * @param string $currentUrl
     * @param null|string $host
     * @param null|string $scheme
     * @return string
     */
    public function urlToAbsolute($currentUrl, $host = null, $scheme = null)
    {
        return $this->builder->urlToAbsolute($currentUrl, $host, $scheme);
    }

    /**
     * @param string $grpIdentifier
     * @param string $identifier
     * @param array $params
     * @return string
     */
    public function buildAbsoluteUrl($grpIdentifier = null, $identifier = null, array $params = [])
    {
        return $this->builder->buildAbsoluteUrl($grpIdentifier, $identifier, $params);
    }

    /**
     * @param string $grpIdentifier
     * @param string $identifier
     * @param array $params
     * @return string
     */
    public function buildUrl($grpIdentifier = null, $identifier = null, array $params = [])
    {
        return $this->builder->buildUrl($grpIdentifier ?: 'default', $identifier, $params);
    }
}
